package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.Study;
import gov.va.med.mhv.bluebutton.transfer.StudyDTO;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class StudyListConverter implements Converter<List<Study>, List<StudyDTO>> {

	@Autowired
	StudyConverter studyConverter;
	
	@Override
	public List<StudyDTO> convert(List<Study> source) {
		List<StudyDTO> d = new ArrayList<StudyDTO>();
		if( source != null && source.size() != 0) {
			for(Study s : source) {
				d.add(studyConverter.convert(s));
			}
		}
		return d;
	}

}
